﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Umowa o dzieło</title>
		<script runat="server">

	public class Params: ContextBase {
	
		public Params(Context context): base(context) {
			okres = ((OkresContext)context[typeof(OkresContext)]).Okres;
		}
		
		FromTo okres;
		[Required]
		public FromTo Okres {
			get { return okres; }
			set {
				okres = value==FromTo.Empty ? FromTo.All : value;
				OnChanged(EventArgs.Empty);
			}
		}
	}
	
	Params pars;
	[Context]
	public Params Pars {
		set { pars = value; }
	}

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool pelnaFunkcja = false;
        [Priority(2)]
        [Caption("Funkcja pełna nazwa")]
        public bool PelnaFunkcja {
            get { return pelnaFunkcja; }
            set {
                pelnaFunkcja = value;
                OnChanged(EventArgs.Empty);
            }
        }        
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    	
    void dc_ContextLoad(Object sender, EventArgs e) {
		PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
		
		ReportHeader1["OKRES"] = pars.Okres.ToString();
		Grid1.DataSource = ph.Pracownik.Historia.GetIntersectedRows(pars.Okres);		
    }
    
    PracHistoria prev = null;
    bool zmiany;
    
    void Grid1_OnBeforeRow(Object sender, RowEventArgs e) {
		PracHistoria ph = (PracHistoria)e.Row;
		
		if (prev!=null && prev.Pracownik!=ph.Pracownik)
			prev = null;
		if ((ph.Aktualnosc*pars.Okres)==FromTo.Empty)
			e.VisibleRow = false;
		else {		
			zmiany = false;
			
			colEtatFrom.AddLine(Bold(ph.Etat.Okres.From.ToString(), prev!=null && prev.Etat.Okres.From!=ph.Etat.Okres.From));
			
			Date to = ph.Etat.Okres.To;
			colZwolnienie.AddLine(Bold(Nbsp(to), prev!=null && prev.Etat.Okres.To!=to));
			colZwolnienie.AddLine(Bold(Nbsp(ph.Etat.PrzyczynaRozwUmowy), prev!=null && prev.Etat.PrzyczynaRozwUmowy!=ph.Etat.PrzyczynaRozwUmowy));

            colStanowisko.AddLine(Bold(Nbsp(GetStanowisko(ph)), prev != null && GetStanowisko(prev) != GetStanowisko(ph)));
            colStanowisko.AddLine(Bold(Nbsp(GetFunkcja(ph)), prev != null && GetFunkcja(prev) != GetFunkcja(ph)));

			colTypUmowy.AddLine(Bold(ph.Etat.TypUmowy, prev!=null && prev.Etat.TypUmowy!=ph.Etat.TypUmowy));
			
			colRodzaj.AddLine(Bold(ph.Etat.RodzajZatrudnienia, prev!=null && prev.Etat.RodzajZatrudnienia!=ph.Etat.RodzajZatrudnienia));
			
			colKalendarz.AddLine(Bold(ph.Etat.Kalendarz, prev!=null && prev.Etat.Kalendarz!=ph.Etat.Kalendarz));
			
			colKodZawodu.AddLine(Bold(ph.Etat.KodWykonywanegoZawodu, prev!=null && prev.Etat.KodWykonywanegoZawodu!=ph.Etat.KodWykonywanegoZawodu));
			
			colGrupa.AddLine(Bold(ph.Etat.Grupa, prev!=null && prev.Etat.Grupa!=ph.Etat.Grupa));
			
			colWymiar.AddLine(Bold(ph.Etat.Zaszeregowanie.Wymiar, prev!=null && prev.Etat.Zaszeregowanie.Wymiar!=ph.Etat.Zaszeregowanie.Wymiar));

			bool bold = prev!=null && 
				(prev.Etat.Zaszeregowanie.TypStawki!=ph.Etat.Zaszeregowanie.TypStawki ||
                prev.Etat.Zaszeregowanie.Stawka.Symbol != ph.Etat.Zaszeregowanie.Stawka.Symbol ||
                prev.Etat.Zaszeregowanie.Stawka.Value != ph.Etat.Zaszeregowanie.Stawka.Value ||
                prev.Etat.Zaszeregowanie.RodzajStawki != ph.Etat.Zaszeregowanie.RodzajStawki);
				
			if (ph.Etat.Zaszeregowanie.TypStawki==TypStawkiZaszeregowania.Minimalna)
				colStawka.AddLine(Bold("minimalna", bold));
			else {
				colStawka.AddLine(Bold(ph.Etat.Zaszeregowanie.Stawka.ToString(), bold));
				colStawka.AddLine(Bold(ph.Etat.Zaszeregowanie.RodzajStawki==RodzajStawkiZaszeregowania.Godzinowa ? "/godz." : "/mies.", bold));
			}
			
			//e.VisibleRow = zmiany;
					
		}
		prev = ph;
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }

    string GetFunkcja(PracHistoria ph) {
        string funkcjaPelna = "";
        if (srpars.PelnaFunkcja)
            funkcjaPelna = ph.Etat.FunkcjaPełna;
        if (funkcjaPelna.Length == 0)
            funkcjaPelna = ph.Etat.Funkcja;
        return funkcjaPelna;
    }
    
    string Nbsp(string value) {
		return value=="" ? "&nbsp;" : value;
    }
    
    string Nbsp(Date date) {
		return date==Date.MinValue || date==Date.MaxValue ? "&nbsp;" : date.ToString();
    }
    
    string Bold(string value, bool bold) {
		zmiany |= bold;
		return bold ? "<strong>" + value + "</strong>" : value;
    }
    
    string Bold(Enum value, bool bold) {
		return Bold(CaptionAttribute.EnumToString(value), bold);
    }
    
    string Bold(IRow value, bool bold) {
		return Bold(value==null ? "&nbsp;" : value.ToString(), bold);
    }
    
    string Bold(int value, bool bold) {
		return Bold(value==0 ? "&nbsp;" : value.ToString(), bold);
    }
    
    string Bold(Fraction value, bool bold) {
		return Bold(value==0 ? "&nbsp;" : value.ToString(), bold);
    }

		</script>
		<meta content="False" name="vs_showGrid">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaODzieło" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" OnContextLoad="dc_ContextLoad" TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace"
				Landscape="True" />
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA O ZMIANIE WARUNKÓW ZATRUDNIENIA|</strong>Pracownik: <strong>{0}|</strong>Za okres:<strong> %OKRES%"
				runat="server" DataMember0="Pracownik"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace"
				onbeforerow="Grid1_OnBeforeRow">
				<Columns>
					<ea:GridColumn Width="10" Align="Center" DataMember="Aktualnosc.From" Caption="Aktualny~od" Format="{0:b}"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" DataMember="Aktualnosc.To" Caption="Aktualny~do" Format="{0:b}"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Center" Caption="Data zatrudnienia" ID="colEtatFrom"></ea:GridColumn>
					<ea:GridColumn Caption="Data zwolnienia|Przyczyna" ID="colZwolnienie"></ea:GridColumn>
					<ea:GridColumn Width="20" Caption="Stanowisko|Funkcja" ID="colStanowisko"></ea:GridColumn>
					<ea:GridColumn Width="14" Caption="Typ umowy" ID="colTypUmowy"></ea:GridColumn>
					<ea:GridColumn Width="14" Caption="Rodzaj zatrudnienia" ID="colRodzaj"></ea:GridColumn>
					<ea:GridColumn Width="14" Caption="Kalendarz" ID="colKalendarz"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Center" Caption="Kod zawodu" ID="colKodZawodu"></ea:GridColumn>
					<ea:GridColumn Width="14" Caption="Zaszeregowanie~nazwa" ID="colGrupa"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Zaszeregowanie~wymiar" ID="colWymiar"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" Caption="Zaszeregowanie~stawka" ID="colStawka"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>
